; (*| 18:20 28/06/1989 *)
TITLE	MAKEROOM
PAGE	60,78

LF	EQU 0AH
CR	EQU 0DH
SAVE_LEN	EQU	960	 ;12 x 80
MAX_MSG_LEN	EQU	78

DOSV_SETCURS	EQU 2	 
DOSV_RDCURS	EQU 3	 
DOSV_WRCHAR	EQU 0AH
DOSV_WRASTTY	EQU 0EH 	; Write character as TTY
DOSV_GETVMODE	EQU 0FH 	; Get Current Video Mode
DOSF_OUTSTR	EQU 09H		; Output string
DOSF_SIVEC	EQU 25H		; Set interrupt vector
DOSF_KEEP	EQU 31H 	; Advanced KEEP
DOSF_GETIVEC	EQU 35H 	; Get interrupt vector
DOSF_TERMPROC	EQU 4CH
DOSF_FREEMEM	EQU 49H
DOSF_IN_VARS	EQU 52H


DOSI_KEYACTION	EQU 09H 	; Keyboard action
DOSI_VIDEO	EQU 10H 	; Video interrupt
DOSI_KEYBOARD	EQU 16H 	; Keyboard services
DOSI_TERM	EQU 20H		; Program terminate
DOSI_FUNC	EQU 21H		; Perform a function
DOSI_TERMR	EQU 27H		; Program terminate and stay resident

VECT_TABLE	SEGMENT AT 0
	ORG	24H
INT9VECT	DW	?
INT9VECTCS	DW	?
VECT_TABLE	ENDS

BIOSDATA	SEGMENT AT 40H
	ORG	10H
EQUIP_FLAG	DW	?
	ORG	17H
KB_FLAG DB	?
	ORG	49H
CRT_MODE	DB	?
CRT_COLS	DW	?
	ORG	50H
CURS0_COL	DB	?
CURS0_ROW	DB	?
	ORG	60H
CURSOR_MODE	DW	?
ACTIVE_PAGE	DB	?
ADDR_6845	DW	?
CRT_MODE_SET	DB	?
CRT_PALETTE	DB	?
	ORG	6CH
TIMER_LOW	DW	?	;18 per sec
TIMER_HIGH	DW	?
TIMER_OFL	DW	?
BIOSDATA	ENDS

MONO_VIDEO	EQU 0B000H
CGA_VIDEO	EQU 0B800H

PCUPOP	SEGMENT
	ASSUME	CS:PCUPOP,DS:PCUPOP,ES:PCUPOP
	ORG	100H
BEGIN:	JMP	INSTALL
POP_MODE	DB	0
ASCII_MODE	DB	0
ASCII_START	DB	0
		DB	0
KEYBDVECT	DD	(?)	;old interrupt address
VID_COLS	DW	80
VID_ROWS	DB	12
VID_SIZE	DW	SAVE_LEN
VID_BASE	DW	CGA_VIDEO
VID_START	DW	0
VID_BUFFER	DW	SAVE_LEN DUP (?)
POPMSG	DB	'MAKEROOM Test Message, F10 to remove, else ESC$'
POPMSG_LEN	EQU	13
ENDMSG	DB	CR,LF,'Make room is now removed.'
	DB	CR,LF,'$'
KEYBDINTNEW:
KB	PROC FAR
	STI
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	MOV	AX,40H
	MOV	DS,AX

	ASSUME	DS:BIOSDATA
	CMP	BYTE PTR CS:POP_MODE,0
	JZ	READ_FIRST_KEY
	JMP	WAIT_ESC
READ_FIRST_KEY:
	IN	AL,60H		;Read from keyboard
	CMP	AL,30		;The 'A' key
	JZ	READ_REST
JMP_NOT_FOR_US:
	JMP	NOT_FOR_US
READ_REST:
	MOV	AL,KB_FLAG
	AND	AL,0FH
	CMP	AL,05H		;Ctrl and Right Shift ?
	JNZ	JMP_NOT_FOR_US
	MOV	AX,CRT_COLS
	MOV	CS:VID_COLS,AX
	MOV	CL,CS:VID_ROWS
	MUL	CL
	MOV	CS:VID_SIZE,AX
	MOV	BYTE PTR CS:POP_MODE,0FFH	;Set flag
	SUB	BX,BX
	MOV	BL,ACTIVE_PAGE
	ADD	BL,BL
	MOV	AL,BYTE PTR CURS0_ROW[BX]
	CMP	AL,11
	MOV	CL,0
	JA	UPPER_SCREEN
	MOV	CL,12
UPPER_SCREEN:
	MOV	AX,CRT_COLS
	SHR	AX,1
	SHR	AX,1
	SHR	AX,1		;div 8: *2 /16
	MUL	CL
	ADD	AX,CS:VID_BASE
	MOV	CS:VID_START,AX
	CALL	SAVE_SCREEN
	MOV	DX,0		;line n
	MOV	AH,0CH		;screen attributes (light red on black)
	MOV	SI,OFFSET CS:POPMSG
	CALL	WRITE_SCREEN
POP_END:
	IN	AL,61H		;Read keyboard control port
	MOV	AH,AL
	OR	AL,80H
	OUT	61H,AL		;Tell the keyboard OK
	MOV	AL,AH	
	OUT	61H,AL		;Restore old value
	CLI
	MOV	AL,20H		;EOI command
	OUT	20H,AL		; to 8259 
	POP	ES
	POP	DS
	POP	DI	 
	POP	SI	 
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	IRET			;End of interrupt processing

NOT_FOR_US:
	POP	ES
	POP	DS
	POP	DI	 
	POP	SI	 
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	JMP	DWORD PTR CS:KEYBDVECT	;Continue with old interrupt routine

;	 DB	 0EAH		 ;jmp
;KEYBDVECT	 DW	 (?)	 ;to old interrupt address
;KEYBDVECTCS	 DW	 (?)

WAIT_ESC:
	IN	AL,60H		;Read from keyboard
	CMP	AL,7FH
	JA	NOT_FOR_US	;Process key release operations
	CMP	AL,68		;The F10 key
	JZ	TERM_POPUP
	CMP	AL,01H		;The ESC key
	JNZ	POP_END 	;Else ignore key press
	MOV	BYTE PTR CS:POP_MODE,0	;Clear flag
	CALL	RESTORE_SCREEN		      
	JMP	POP_END

TERM_POPUP:
	CALL	RESTORE_SCREEN		      
	PUSH	DS
	SUB	AX,AX
	MOV	DS,AX
	ASSUME	DS:VECT_TABLE
	MOV	AX,WORD PTR CS:KEYBDVECT
	MOV	INT9VECT,AX
	MOV	AX,WORD PTR CS:KEYBDVECT+2
	MOV	INT9VECTCS,AX	;Old vector restored
	POP	DS
	ASSUME	DS:BIOSDATA
	MOV	SI,OFFSET CS:ENDMSG
	CALL	OUTPUT		;Sign off
	PUSH	CS
	POP	ES
	MOV	AH,DOSF_FREEMEM
	INT	DOSI_FUNC	;Release memory occupied by this program
	JMP	POP_END
KB	ENDP

OUTPUT	PROC NEAR
	MOV	AH,DOSV_WRASTTY ;write char func
	MOV	AL,CS:[SI]
	CMP	AL,'$'
	JZ	END_OF_STRING
	INT	DOSI_VIDEO
	INC	SI
	JMP	OUTPUT
END_OF_STRING:
	RET
OUTPUT	ENDP

SAVE_SCREEN	PROC	NEAR
	PUSH	DS
	PUSH	ES
	MOV	CX,CS:VID_SIZE
	MOV	AX,CS:VID_START
	MOV	DS,AX
	PUSH	CS
	POP	ES		;ES:=CS
	MOV	SI,0
	MOV	DI,OFFSET CS:VID_BUFFER
	REPZ	MOVSW	   
	POP	ES
	POP	DS
	RET
SAVE_SCREEN	ENDP

; DX=START OFFSET, CX=HEIGHT, BX=WIDTH, AH=COLOUR ATTRIBUTES

DRAW_BOX	PROC	NEAR
	PUSH	DX		;line n
	SUB	CX,2
	PUSH	CX
	PUSH	DX
	MOV	AL,201		;top left corner
	CALL	WRITE_CHAR
	MOV	CX,BX
	MOV	AL,205		;horizontal
	CALL	WRITE_MANY_CHAR
	MOV	AL,187		;top right corner
	CALL	WRITE_CHAR
	POP	DX
	POP	CX

DB_LOOP:
	ADD	DX,CS:VID_COLS	;line n+1
	PUSH	CX
	PUSH	DX
	MOV	AL,186		;vertical
	CALL	WRITE_CHAR
	MOV	CX,BX
	MOV	AL,' '
	CALL	WRITE_MANY_CHAR
	MOV	AL,186		;vertical
	CALL	WRITE_CHAR
	MOV	AL,200		;bottom left
	POP	DX
	POP	CX
	LOOP	DB_LOOP

	ADD	DX,CS:VID_COLS	;line n+2
	CALL	WRITE_CHAR
	MOV	CX,BX
	MOV	AL,205		;horizontal
	CALL	WRITE_MANY_CHAR
	MOV	AL,188		;bottom right
	CALL	WRITE_CHAR
	POP	DX
	ADD	DX,CS:VID_COLS
	ADD	DX,1		;line n+1, col 2
	RET
DRAW_BOX	ENDP


;	SI=START OF STRING, AH=SCREEN ATTRIBUTE, DX=VIDEO OFFSET

WRITE_SCREEN	PROC	NEAR
	PUSH	DS
	PUSH	ES
	MOV	CX,MAX_MSG_LEN	;Limit max length of string
	PUSH	CS
	POP	DS		;DS:=CS
	PUSH	AX
	MOV	AX,CS:VID_START
	MOV	ES,AX
	POP	AX
	ADD	DX,DX		;2 bytes for Char+Attrib
	MOV	DI,DX
WS_LOOP:
	LODSB
	CMP	AL,'$'
	JZ	END_OF_WRITE
	STOSB
	MOV	AL,AH
	STOSB
	LOOP	WS_LOOP
END_OF_WRITE:
	POP	ES
	POP	DS
	RET
WRITE_SCREEN	ENDP

;	AL=CHAR, AH=SCREEN ATTRIBUTE, DX=VIDEO OFFSET
;	DX INCREMENTED

WRITE_CHAR	PROC	NEAR
	PUSH	DS
	PUSH	ES
	PUSH	AX
	MOV	AX,CS:VID_START
	MOV	ES,AX
	POP	AX
	MOV	DI,DX
	ADD	DI,DX
	STOSW
	INC	DX
	POP	ES
	POP	DS
	RET
WRITE_CHAR	ENDP

;	AL=CHAR, AH=SCREEN ATTRIBUTE, CX=COUNT, DX=VIDEO OFFSET

WRITE_MANY_CHAR      PROC    NEAR
	JCXZ	DONE_MANY_CHAR
NEXT_MANY:
	CALL	WRITE_CHAR
	LOOP	NEXT_MANY
DONE_MANY_CHAR:
	RET
WRITE_MANY_CHAR      ENDP

RESTORE_SCREEN	PROC	NEAR
	PUSH	DS
	PUSH	ES
	MOV	CX,CS:VID_SIZE
	PUSH	CS
	POP	DS		;DS:=CS
	MOV	AX,CS:VID_START
	MOV	ES,AX
	MOV	SI,OFFSET CS:VID_BUFFER
	MOV	DI,0
	REPZ	MOVSW	   
	POP	ES
	POP	DS
	RET
RESTORE_SCREEN	ENDP

; AL=CHAR, AH=ATTRIBUTE, DX=SCREEN OFFSET

THIS_SITE	LABEL NEAR
SPAN	EQU	THIS_SITE - BEGIN

IF	SPAN MOD 16
	ORG	(THIS_SITE + 16) - (SPAN MOD 16)
ENDIF

ENV_SEG EQU	WORD PTR BEGIN-0D4H

OLD_CPY DB	0
NEW_CPY DB	0

INSTALL:
	PUSH	CS
	POP	DS

;	PUSH	DS
;	MOV	AX,40H
;	MOV	DS,AX
;	ASSUME	DS:BIOSDATA
;	MOV	DL,CRT_MODE
;	POP	DS
;	ASSUME	DS:PCUPOP
	MOV	AH,DOSV_GETVMODE
	INT	DOSI_VIDEO
	MOV	DL,AL			; Returned video mode
	MOV	AX,MONO_VIDEO
	CMP	DL,7
	JZ	VID_SET
	MOV	AX,CGA_VIDEO
VID_SET:	MOV	CS:VID_BASE,AX
	MOV	ES,ENV_SEG
	MOV	AH,DOSF_FREEMEM 
	INT	DOSI_FUNC
	CALL	RESIDENT		;Check if already installed
	MOV	AL,DOSI_KEYACTION
	MOV	DI,OFFSET KEYBDVECT
	MOV	DX,OFFSET KEYBDINTNEW
	CALL	SET_VEC
	MOV	AH,DOSF_OUTSTR
	MOV	DX,OFFSET OKMSG
	INT	DOSI_FUNC
	MOV	AX,CS
	MOV	AL,AH
	CALL	WRITE2HEX
	MOV	AX,CS
	CALL	WRITE2HEX
	MOV	AH,DOSV_WRASTTY
	MOV	AL,':'
	INT	DOSI_VIDEO
	MOV	CX,OFFSET KB
	MOV	AL,CH
	CALL	WRITE2HEX
	MOV	AL,CL
	CALL	WRITE2HEX
	MOV	DX,OFFSET CRLFMSG
	INT	DOSI_FUNC
;	 MOV	 DX,OFFSET INSTALL
;	 MOV	 CL,4
;	 SHR	 DX,CL
	MOV	DX,0800H		; 32k paragraphs
	MOV	AX,CS
	AND	AX,07FFH
	JZ	ALIGN_OK
	MOV	DX,1000H
	SUB	DX,AX
ALIGN_OK:
	MOV	AH,DOSF_KEEP
	INT	DOSI_FUNC

RESIDENT	PROC	NEAR
	MOV	DX,WORD PTR DS:[2]	;Top of memory from PSP
	MOV	AH,DOSF_IN_VARS
	INT	DOSI_FUNC
	MOV	AX,ES:[BX-2]
	MOV	ES,AX			; Segment address of first block

NEXT_BLOCK:
	CALL	REACH
	CMP	AX,DX
	JAE	REACHED_TOP
	CMP	CL,'M'
	JE	BLOCK_OK
	CMP	CL,'Z'
	JE	BLOCK_OK
BAD_MEM:
	MOV	DX,OFFSET MEMMSG
	JMP	SHORT MSGTERM		      ;while in this loop

BLOCK_OK:
	MOV	AX,WORD PTR ES:[1]
	MOV	CX,CS
	CMP	AX,CX
	JNE	NOT_THIS_COPY
	INC	CS:NEW_CPY
	JMP	SHORT NEXT_BLOCK

NOT_THIS_COPY:
	PUSH	ES
	MOV	ES,AX
	MOV	SI,OFFSET KB
	MOV	DI,SI
	MOV	CX,32
	CLD
	REPE	CMPSB
	POP	ES
	JCXZ	FOUND_OLD
	JMP	NEXT_BLOCK

FOUND_OLD:
	INC	CS:OLD_CPY
	JMP	NEXT_BLOCK

REACHED_TOP:
	CMP	CS:OLD_CPY,0
	JE	NOT_FOUND_OLD

	MOV	DX,OFFSET EXIMSG
MSGTERM:
	PUSH	DX
	MOV	DX,OFFSET NOTMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	POP	DX
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AH,DOSF_TERMPROC
	INT	DOSI_FUNC

NOT_FOUND_OLD:
	CMP	CS:NEW_CPY,0
	JE	BAD_MEM
	RET
RESIDENT	ENDP


SET_VEC PROC	NEAR
	PUSH	AX
	MOV	AH,DOSF_GETIVEC
	INT	DOSI_FUNC
	MOV	[DI],BX
	MOV	[DI+2],ES
	POP	AX
	MOV	AH,DOSF_SIVEC
	INT	DOSI_FUNC
	RET
SET_VEC ENDP	    

REACH	PROC	NEAR
	MOV	AX,ES
	ADD	AX,WORD PTR ES:[3]
	INC	AX
	MOV	ES,AX
	MOV	CL,BYTE PTR ES:[0]
	RET
REACH	ENDP

WRITE2HEX	PROC	NEAR
	PUSH	AX
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	CALL	WRITE1HEX
	POP	AX
	CALL	WRITE1HEX
	RET
WRITE2HEX	ENDP

WRITE1HEX	PROC	NEAR
	PUSH	AX
	AND	AL,0FH
	OR	AL,'0'
	CMP	AL,'9'+1
	JB	W1HEXOK
	ADD	AL,7
W1HEXOK:
	MOV	AH,DOSV_WRASTTY
	INT	DOSI_VIDEO
	POP	AX
	RET
WRITE1HEX	ENDP

OKMSG	DB	'MAKEROOM v1.0 is now installed at $'
NOTMSG	DB	CR,LF,'MAKEROOM not installed ...'
CRLFMSG DB	CR,LF,'$'
EXIMSG	DB	'Resident copy of MAKEROOM already exists.',CR,LF,'$'
MEMMSG	DB	'Memory allocation is in error.',CR,LF,'$'
FAIMSG	DB	'This copy of MAKEROOM may be defective.',CR,LF,'$'

PCUPOP	ENDS
	END	BEGIN
	
